/*
 *  linux/arch/arm/mach-uniphier/serial.c
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/resource.h>
#include <linux/serial.h>
#include <linux/serial_8250.h>

#include <mach/serial.h>

static struct plat_serial8250_port serial_platform_data[] = {
#ifdef CONFIG_UNIPHIER_UART0
	{
		.iobase		= (unsigned long)UNIPHIER_UART0_BASE,
		.membase	= (char *)UNIPHIER_UART0_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART0_BASE,
		.irq		= IRQ_UNIPHIER_UART0,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART0 */
#ifdef CONFIG_UNIPHIER_UART1
	{
		.iobase		= (unsigned long)UNIPHIER_UART1_BASE,
		.membase	= (char *)UNIPHIER_UART1_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART1_BASE,
		.irq		= IRQ_UNIPHIER_UART1,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART1 */
#ifdef CONFIG_UNIPHIER_UART2
	{
		.iobase		= (unsigned long)UNIPHIER_UART2_BASE,
		.membase	= (char *)UNIPHIER_UART2_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART2_BASE,
		.irq		= IRQ_UNIPHIER_UART2,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART2 */
#ifdef CONFIG_UNIPHIER_UART3
	{
		.iobase		= (unsigned long)UNIPHIER_UART3_BASE,
		.membase	= (char *)UNIPHIER_UART3_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART3_BASE,
		.irq		= IRQ_UNIPHIER_UART3,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART3 */
#ifdef CONFIG_UNIPHIER_UART4
	{
		.iobase		= (unsigned long)UNIPHIER_UART4_BASE,
		.membase	= (char *)UNIPHIER_UART4_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART4_BASE,
		.irq		= IRQ_UNIPHIER_UART4,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART4 */
#ifdef CONFIG_UNIPHIER_UART5
	{
		.iobase		= (unsigned long)UNIPHIER_UART5_BASE,
		.membase	= (char *)UNIPHIER_UART5_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART5_BASE,
		.irq		= IRQ_UNIPHIER_UART5,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART5 */
#ifdef CONFIG_UNIPHIER_UART6
	{
		.iobase		= (unsigned long)UNIPHIER_UART6_BASE,
		.membase	= (char *)UNIPHIER_UART6_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_UART6_BASE,
		.irq		= IRQ_UNIPHIER_UART6,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_UNIPHIER,
		.regshift	= 0,
		.uartclk	= UNIPHIER_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_UNIPHIER_UART6 */
#ifdef CONFIG_SC_UART
	{
		.iobase		= (unsigned long)UNIPHIER_SC_UART_BASE,
		.membase	= (char *)UNIPHIER_SC_UART_BASE,
		.mapbase	= (resource_size_t)UNIPHIER_SC_UART_BASE,
		.irq		= UNIPHIER_SC_UART_IRQ,
		.flags		= UPF_BOOT_AUTOCONF | UPF_SKIP_TEST,
		.iotype		= UPIO_MEM,
		.regshift	= UNIPHIER_SC_UART_REG_SHIFT,
		.uartclk	= UNIPHIER_SC_UART_BASE_BAUD * 16,
	},
#endif /* CONFIG_SC_UART */
	{
		.flags		= 0
	}
};

static struct platform_device uniphier_serial_device = {
	.name			= "serial8250",
	.id			= PLAT8250_DEV_PLATFORM,
	.dev			= {
		.platform_data	= serial_platform_data,
	},
};

int __init uniphier_serial_init(void)
{
	return platform_device_register(&uniphier_serial_device);
}
arch_initcall(uniphier_serial_init);
